<?php

Route::redirect('/', '/login');
Route::get('/home', function () {
    if (session('status')) {
        return redirect()->route('admin.home')->with('status', session('status'));
    }

    return redirect()->route('admin.home');
});

Auth::routes();

Route::group(['prefix' => 'admin', 'as' => 'admin.', 'namespace' => 'Admin', 'middleware' => ['auth']], function () {
    Route::get('/', 'HomeController@index')->name('home');
    // Permissions
    Route::delete('permissions/destroy', 'PermissionsController@massDestroy')->name('permissions.massDestroy');
    Route::resource('permissions', 'PermissionsController');

    // Roles
    Route::delete('roles/destroy', 'RolesController@massDestroy')->name('roles.massDestroy');
    Route::resource('roles', 'RolesController');

    // Users
    Route::delete('users/destroy', 'UsersController@massDestroy')->name('users.massDestroy');
    Route::resource('users', 'UsersController');

    // Team
    Route::delete('teams/destroy', 'TeamController@massDestroy')->name('teams.massDestroy');
    Route::resource('teams', 'TeamController');

    // Debitos Gerais
    Route::delete('debitos-gerais/destroy', 'DebitosGeraisController@massDestroy')->name('debitos-gerais.massDestroy');
    Route::post('debitos-gerais/parse-csv-import', 'DebitosGeraisController@parseCsvImport')->name('debitos-gerais.parseCsvImport');
    Route::post('debitos-gerais/process-csv-import', 'DebitosGeraisController@processCsvImport')->name('debitos-gerais.processCsvImport');
    Route::resource('debitos-gerais', 'DebitosGeraisController');

    // Menu Multas
    Route::delete('menu-multa/destroy', 'MenuMultasController@massDestroy')->name('menu-multa.massDestroy');
    Route::post('menu-multa/parse-csv-import', 'MenuMultasController@parseCsvImport')->name('menu-multa.parseCsvImport');
    Route::post('menu-multa/process-csv-import', 'MenuMultasController@processCsvImport')->name('menu-multa.processCsvImport');
    Route::resource('menu-multa', 'MenuMultasController');

    // Condutores
    Route::delete('condutores/destroy', 'CondutoresController@massDestroy')->name('condutores.massDestroy');
    Route::post('condutores/parse-csv-import', 'CondutoresController@parseCsvImport')->name('condutores.parseCsvImport');
    Route::post('condutores/process-csv-import', 'CondutoresController@processCsvImport')->name('condutores.processCsvImport');
    Route::resource('condutores', 'CondutoresController');

    // Meuscondutores
    Route::delete('meuscondutores/destroy', 'MeuscondutoresController@massDestroy')->name('meuscondutores.massDestroy');
    Route::post('meuscondutores/parse-csv-import', 'MeuscondutoresController@parseCsvImport')->name('meuscondutores.parseCsvImport');
    Route::post('meuscondutores/process-csv-import', 'MeuscondutoresController@processCsvImport')->name('meuscondutores.processCsvImport');
    Route::resource('meuscondutores', 'MeuscondutoresController');

    // Meusveiculos
    Route::delete('meusveiculos/destroy', 'MeusveiculosController@massDestroy')->name('meusveiculos.massDestroy');
    Route::post('meusveiculos/media', 'MeusveiculosController@storeMedia')->name('meusveiculos.storeMedia');
    Route::post('meusveiculos/ckmedia', 'MeusveiculosController@storeCKEditorImages')->name('meusveiculos.storeCKEditorImages');
    Route::post('meusveiculos/parse-csv-import', 'MeusveiculosController@parseCsvImport')->name('meusveiculos.parseCsvImport');
    Route::post('meusveiculos/process-csv-import', 'MeusveiculosController@processCsvImport')->name('meusveiculos.processCsvImport');
    Route::resource('meusveiculos', 'MeusveiculosController');

    Route::get('team-members', 'TeamMembersController@index')->name('team-members.index');
    Route::post('team-members', 'TeamMembersController@invite')->name('team-members.invite');
});
Route::group(['prefix' => 'profile', 'as' => 'profile.', 'namespace' => 'Auth', 'middleware' => ['auth']], function () {
    // Change password
    if (file_exists(app_path('Http/Controllers/Auth/ChangePasswordController.php'))) {
        Route::get('password', 'ChangePasswordController@edit')->name('password.edit');
        Route::post('password', 'ChangePasswordController@update')->name('password.update');
        Route::post('profile', 'ChangePasswordController@updateProfile')->name('password.updateProfile');
        Route::post('profile/destroy', 'ChangePasswordController@destroy')->name('password.destroyProfile');
    }
});
