@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.show') }} {{ trans('cruds.meusveiculo.title') }}
    </div>

    <div class="card-body">
        <div class="form-group">
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.meusveiculos.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
            <table class="table table-bordered table-striped">
                <tbody>
                    <tr>
                        <th>
                            {{ trans('cruds.meusveiculo.fields.placa') }}
                        </th>
                        <td>
                            {{ $meusveiculo->placa }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.meusveiculo.fields.renavam') }}
                        </th>
                        <td>
                            {{ $meusveiculo->renavam }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.meusveiculo.fields.chassi') }}
                        </th>
                        <td>
                            {{ $meusveiculo->chassi }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.meusveiculo.fields.marca_modelo') }}
                        </th>
                        <td>
                            {{ $meusveiculo->marca_modelo }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.meusveiculo.fields.cor') }}
                        </th>
                        <td>
                            {{ $meusveiculo->cor }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.meusveiculo.fields.anomodelo') }}
                        </th>
                        <td>
                            {{ $meusveiculo->anomodelo }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.meusveiculo.fields.status') }}
                        </th>
                        <td>
                            {{ App\Models\Meusveiculo::STATUS_SELECT[$meusveiculo->status] ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.meusveiculo.fields.empresa') }}
                        </th>
                        <td>
                            {{ $meusveiculo->empresa }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.meusveiculo.fields.cpfcnpj') }}
                        </th>
                        <td>
                            {{ $meusveiculo->cpfcnpj }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.meusveiculo.fields.setor') }}
                        </th>
                        <td>
                            {{ $meusveiculo->setor }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.meusveiculo.fields.seguradora') }}
                        </th>
                        <td>
                            {{ $meusveiculo->seguradora }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.meusveiculo.fields.tag') }}
                        </th>
                        <td>
                            {{ $meusveiculo->tag }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.meusveiculo.fields.observacao') }}
                        </th>
                        <td>
                            {!! $meusveiculo->observacao !!}
                        </td>
                    </tr>
                </tbody>
            </table>
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.meusveiculos.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
        </div>
    </div>
</div>



@endsection