@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.edit') }} {{ trans('cruds.condutore.title_singular') }}
    </div>

    <div class="card-body">
        <form method="POST" action="{{ route("admin.condutores.update", [$condutore->id]) }}" enctype="multipart/form-data">
            @method('PUT')
            @csrf
            <div class="form-group">
                <label for="nome">{{ trans('cruds.condutore.fields.nome') }}</label>
                <input class="form-control {{ $errors->has('nome') ? 'is-invalid' : '' }}" type="text" name="nome" id="nome" value="{{ old('nome', $condutore->nome) }}">
                @if($errors->has('nome'))
                    <span class="text-danger">{{ $errors->first('nome') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.condutore.fields.nome_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="numero_registro">{{ trans('cruds.condutore.fields.numero_registro') }}</label>
                <input class="form-control {{ $errors->has('numero_registro') ? 'is-invalid' : '' }}" type="number" name="numero_registro" id="numero_registro" value="{{ old('numero_registro', $condutore->numero_registro) }}" step="1">
                @if($errors->has('numero_registro'))
                    <span class="text-danger">{{ $errors->first('numero_registro') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.condutore.fields.numero_registro_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="categoria">{{ trans('cruds.condutore.fields.categoria') }}</label>
                <input class="form-control {{ $errors->has('categoria') ? 'is-invalid' : '' }}" type="text" name="categoria" id="categoria" value="{{ old('categoria', $condutore->categoria) }}">
                @if($errors->has('categoria'))
                    <span class="text-danger">{{ $errors->first('categoria') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.condutore.fields.categoria_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="validade">{{ trans('cruds.condutore.fields.validade') }}</label>
                <input class="form-control date {{ $errors->has('validade') ? 'is-invalid' : '' }}" type="text" name="validade" id="validade" value="{{ old('validade', $condutore->validade) }}">
                @if($errors->has('validade'))
                    <span class="text-danger">{{ $errors->first('validade') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.condutore.fields.validade_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="situacao">{{ trans('cruds.condutore.fields.situacao') }}</label>
                <input class="form-control {{ $errors->has('situacao') ? 'is-invalid' : '' }}" type="text" name="situacao" id="situacao" value="{{ old('situacao', $condutore->situacao) }}">
                @if($errors->has('situacao'))
                    <span class="text-danger">{{ $errors->first('situacao') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.condutore.fields.situacao_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="pontuacao">{{ trans('cruds.condutore.fields.pontuacao') }}</label>
                <input class="form-control {{ $errors->has('pontuacao') ? 'is-invalid' : '' }}" type="number" name="pontuacao" id="pontuacao" value="{{ old('pontuacao', $condutore->pontuacao) }}" step="1">
                @if($errors->has('pontuacao'))
                    <span class="text-danger">{{ $errors->first('pontuacao') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.condutore.fields.pontuacao_helper') }}</span>
            </div>
            <div class="form-group">
                <button class="btn btn-danger" type="submit">
                    {{ trans('global.save') }}
                </button>
            </div>
        </form>
    </div>
</div>



@endsection