<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDebitosGeraisTable extends Migration
{
    public function up()
    {
        Schema::create('debitos_gerais', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('placa')->nullable();
            $table->float('ipva', 15, 2)->nullable();
            $table->float('taxa_de_licenciamento', 15, 2)->nullable();
            $table->float('licenciamento_anteriores', 15, 2)->nullable();
            $table->float('multas', 15, 2)->nullable();
            $table->string('situacao')->nullable();
            $table->string('financiamento')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }
}
