<?php

namespace App\Http\Requests;

use App\Models\Meuscondutore;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class UpdateMeuscondutoreRequest extends FormRequest
{
    public function authorize()
    {
        return Gate::allows('meuscondutore_edit');
    }

    public function rules()
    {
        return [
            'nome' => [
                'string',
                'required',
            ],
            'numregistro' => [
                'string',
                'required',
                'unique:meuscondutores,numregistro,' . request()->route('meuscondutore')->id,
            ],
            'uf' => [
                'required',
            ],
            'validade' => [
                'date_format:' . config('panel.date_format'),
                'nullable',
            ],
            'categoria' => [
                'string',
                'nullable',
            ],
            'status' => [
                'required',
            ],
        ];
    }
}
