<?php

namespace App\Http\Requests;

use App\Models\MenuMultum;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class UpdateMenuMultumRequest extends FormRequest
{
    public function authorize()
    {
        return Gate::allows('menu_multum_edit');
    }

    public function rules()
    {
        return [
            'placa' => [
                'string',
                'required',
            ],
            'auto' => [
                'string',
                'required',
                'unique:menu_multa,auto,' . request()->route('menu_multum')->id,
            ],
            'infracao' => [
                'string',
                'nullable',
            ],
            'orgao_competente' => [
                'string',
                'nullable',
            ],
            'local' => [
                'string',
                'nullable',
            ],
            'situacao' => [
                'string',
                'required',
            ],
            'data_infracao' => [
                'required',
                'date_format:' . config('panel.date_format'),
            ],
            'valor_total' => [
                'numeric',
            ],
            'vencimento_auto' => [
                'date_format:' . config('panel.date_format'),
                'nullable',
            ],
            'auto_gerador' => [
                'string',
                'nullable',
            ],
        ];
    }
}
