<?php

namespace App\Http\Requests;

use App\Models\DebitosGerai;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class UpdateDebitosGeraiRequest extends FormRequest
{
    public function authorize()
    {
        return Gate::allows('debitos_gerai_edit');
    }

    public function rules()
    {
        return [
            'placa' => [
                'string',
                'nullable',
            ],
            'ipva' => [
                'numeric',
                'min:0',
            ],
            'taxa_de_licenciamento' => [
                'numeric',
            ],
            'licenciamento_anteriores' => [
                'numeric',
            ],
            'multas' => [
                'numeric',
            ],
            'situacao' => [
                'string',
                'nullable',
            ],
            'financiamento' => [
                'string',
                'nullable',
            ],
        ];
    }
}
