<?php

namespace App\Http\Requests;

use App\Models\Condutore;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class UpdateCondutoreRequest extends FormRequest
{
    public function authorize()
    {
        return Gate::allows('condutore_edit');
    }

    public function rules()
    {
        return [
            'nome' => [
                'string',
                'nullable',
            ],
            'numero_registro' => [
                'nullable',
                'integer',
                'min:-2147483648',
                'max:2147483647',
            ],
            'categoria' => [
                'string',
                'nullable',
            ],
            'validade' => [
                'date_format:' . config('panel.date_format'),
                'nullable',
            ],
            'situacao' => [
                'string',
                'nullable',
            ],
            'pontuacao' => [
                'nullable',
                'integer',
                'min:-2147483648',
                'max:2147483647',
            ],
        ];
    }
}
