<?php

namespace App\Http\Controllers\Api\V1\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreDebitosGeraiRequest;
use App\Http\Requests\UpdateDebitosGeraiRequest;
use App\Http\Resources\Admin\DebitosGeraiResource;
use App\Models\DebitosGerai;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class DebitosGeraisApiController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('debitos_gerai_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new DebitosGeraiResource(DebitosGerai::with(['team'])->get());
    }

    public function store(StoreDebitosGeraiRequest $request)
    {
        $debitosGerai = DebitosGerai::create($request->all());

        return (new DebitosGeraiResource($debitosGerai))
            ->response()
            ->setStatusCode(Response::HTTP_CREATED);
    }

    public function show(DebitosGerai $debitosGerai)
    {
        abort_if(Gate::denies('debitos_gerai_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new DebitosGeraiResource($debitosGerai->load(['team']));
    }

    public function update(UpdateDebitosGeraiRequest $request, DebitosGerai $debitosGerai)
    {
        $debitosGerai->update($request->all());

        return (new DebitosGeraiResource($debitosGerai))
            ->response()
            ->setStatusCode(Response::HTTP_ACCEPTED);
    }

    public function destroy(DebitosGerai $debitosGerai)
    {
        abort_if(Gate::denies('debitos_gerai_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $debitosGerai->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
