<?php

namespace App\Http\Controllers\Api\V1\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreCondutoreRequest;
use App\Http\Requests\UpdateCondutoreRequest;
use App\Http\Resources\Admin\CondutoreResource;
use App\Models\Condutore;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CondutoresApiController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('condutore_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new CondutoreResource(Condutore::with(['team'])->get());
    }

    public function store(StoreCondutoreRequest $request)
    {
        $condutore = Condutore::create($request->all());

        return (new CondutoreResource($condutore))
            ->response()
            ->setStatusCode(Response::HTTP_CREATED);
    }

    public function show(Condutore $condutore)
    {
        abort_if(Gate::denies('condutore_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new CondutoreResource($condutore->load(['team']));
    }

    public function update(UpdateCondutoreRequest $request, Condutore $condutore)
    {
        $condutore->update($request->all());

        return (new CondutoreResource($condutore))
            ->response()
            ->setStatusCode(Response::HTTP_ACCEPTED);
    }

    public function destroy(Condutore $condutore)
    {
        abort_if(Gate::denies('condutore_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $condutore->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
