<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\CsvImportTrait;
use App\Http\Requests\MassDestroyDebitosGeraiRequest;
use App\Http\Requests\StoreDebitosGeraiRequest;
use App\Http\Requests\UpdateDebitosGeraiRequest;
use App\Models\DebitosGerai;
use App\Models\Team;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Yajra\DataTables\Facades\DataTables;

class DebitosGeraisController extends Controller
{
    use CsvImportTrait;

    public function index(Request $request)
    {
        abort_if(Gate::denies('debitos_gerai_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        if ($request->ajax()) {
            $query = DebitosGerai::with(['team'])->select(sprintf('%s.*', (new DebitosGerai)->table));
            $table = Datatables::of($query);

            $table->addColumn('placeholder', '&nbsp;');
            $table->addColumn('actions', '&nbsp;');

            $table->editColumn('actions', function ($row) {
                $viewGate      = 'debitos_gerai_show';
                $editGate      = 'debitos_gerai_edit';
                $deleteGate    = 'debitos_gerai_delete';
                $crudRoutePart = 'debitos-gerais';

                return view('partials.datatablesActions', compact(
                    'viewGate',
                    'editGate',
                    'deleteGate',
                    'crudRoutePart',
                    'row'
                ));
            });

            $table->editColumn('placa', function ($row) {
                return $row->placa ? $row->placa : '';
            });
            $table->editColumn('ipva', function ($row) {
                return $row->ipva ? $row->ipva : '';
            });
            $table->editColumn('taxa_de_licenciamento', function ($row) {
                return $row->taxa_de_licenciamento ? $row->taxa_de_licenciamento : '';
            });
            $table->editColumn('licenciamento_anteriores', function ($row) {
                return $row->licenciamento_anteriores ? $row->licenciamento_anteriores : '';
            });
            $table->editColumn('multas', function ($row) {
                return $row->multas ? $row->multas : '';
            });
            $table->editColumn('situacao', function ($row) {
                return $row->situacao ? $row->situacao : '';
            });
            $table->editColumn('financiamento', function ($row) {
                return $row->financiamento ? $row->financiamento : '';
            });

            $table->rawColumns(['actions', 'placeholder']);

            return $table->make(true);
        }

        $teams = Team::get();

        return view('admin.debitosGerais.index', compact('teams'));
    }

    public function create()
    {
        abort_if(Gate::denies('debitos_gerai_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.debitosGerais.create');
    }

    public function store(StoreDebitosGeraiRequest $request)
    {
        $debitosGerai = DebitosGerai::create($request->all());

        return redirect()->route('admin.debitos-gerais.index');
    }

    public function edit(DebitosGerai $debitosGerai)
    {
        abort_if(Gate::denies('debitos_gerai_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $debitosGerai->load('team');

        return view('admin.debitosGerais.edit', compact('debitosGerai'));
    }

    public function update(UpdateDebitosGeraiRequest $request, DebitosGerai $debitosGerai)
    {
        $debitosGerai->update($request->all());

        return redirect()->route('admin.debitos-gerais.index');
    }

    public function show(DebitosGerai $debitosGerai)
    {
        abort_if(Gate::denies('debitos_gerai_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $debitosGerai->load('team');

        return view('admin.debitosGerais.show', compact('debitosGerai'));
    }

    public function destroy(DebitosGerai $debitosGerai)
    {
        abort_if(Gate::denies('debitos_gerai_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $debitosGerai->delete();

        return back();
    }

    public function massDestroy(MassDestroyDebitosGeraiRequest $request)
    {
        $debitosGerais = DebitosGerai::find(request('ids'));

        foreach ($debitosGerais as $debitosGerai) {
            $debitosGerai->delete();
        }

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
